#ifndef MODEL_H

#define MODEL_H

#include"rnn.h"
#include"bptt.h"
#include"rankone.h"

template<class Optimizer>
void connectOutToOptimizer(RNN&nw,Optimizer&opt){
 //Connect the output parameters of the model to the
 //optimizer and set the functions necessary for the
 //learning algorithms to learn the output parameters.
 nw.setOutparams(opt.outparams,opt.outdiagregul);
 opt.DLossDoutparams=[&nw](vector<Vector>&grad){
	 nw.DLossDoutparams(grad);
 };
 opt.DLossDV=[&nw](vector<long double>&grad){
	 nw.DLossDV(grad);
 };
}
template<long N,bool b,class T>
void connectModelToOptimizer(RNN&nw,BPTTOptim<N,b,T>&opt,bool updateAct=false){
 //Connect the transition parameter of the model to the
 //optimizer and set the functions necessary for the
 //learning algorithm to learn the transition parameters
 //in the BPTT case.
 connectOutToOptimizer<BPTTOptim<N,b,T>>(nw,opt);
 nw.setTransparams(opt.transparams,opt.transdiagregul);
 opt.DFDTheta=[&nw](vector<Vector>& grad){
	 nw.DFDTheta(grad);
 };
 opt.MultiplyRightDFDV=[&nw](vector<long double>& dv){
  	 nw.MultiplyRightDFDV(dv);
 };
 opt.SaveState=[&nw](){
 	return nw.SaveState();
 };
}
template<class Optimizer>
void connectModelToOptimizer(RNN&nw,Optimizer&opt,bool updateAct=false){ 
 //Connect the transition parameter of the model to the
 //optimizer and set the functions necessary for the
 //learning algorithm to learn the transition parameters
 //in non-BPTT cases.
 connectOutToOptimizer<Optimizer>(nw,opt);
 nw.setTransparams(opt.transparams,opt.transdiagregul);
 opt.DFDTheta=[&nw](vector<Vector>& grad){
	 nw.DFDTheta(grad);
 };
 opt.ApplyDFDV=[&nw](vector<long double>& dv){
 	 nw.ApplyDFDV(dv);
 };
 if(updateAct){
 	opt.UpdateAct=[&nw](const vector<long double>& dv){
		 nw.UpdateAct(dv);
 	};
 }
}

#endif
