#ifndef _NEURAL_NETWORK_H
#define _NEURAL_NETWORK_H 1

#include<iostream>
#include<vector>
#include<cmath>
#include"rand.h"
#include<cfloat>
#include<map>

#include"vector.h"

using namespace std;

long double inftheorysequence(long n);

extern const long double epsilon;
bool isToPredict(const vector<long>&datum,long pos);


struct PredictorNetwork{
	long alph; //alphabet size
	int n; //Network size
	int conn; //Network connectivity (edges per unit)
	virtual int suggestedConn()=0;// suggestion of connectivity to balance out various terms in the algorithmic cost of training. Needs to have other parameters already set
	int nedges; //usually n*conn
	vector<int> edgesrc,edgedest; //for an integer e in [0;nedges), edgesrc[e] and edgedest[e] are the source and target of edge e
	vector<vector<pair<int,int> > > edgesto,edgesfrom;//edge reverse index: edgesto[j] is a vector containing all pairs (i,e) where e is an edge from i to j, and likewise edgesfrom[i] is a vector containing all pairs (j,e) with e an edge from i to j

	vector< long double> pred;  //pred[x] = predicted probability to have symbol x at current time
	//vector<long double> readfreq,predfreq; //average symbol frequencies in the data
	long last_symbol_read;

	PredictorNetwork();
	virtual ~PredictorNetwork();
	virtual void buildCompleteGraph(int an);
	virtual void buildErdosRenyi_loops(int an,int aconn);
	virtual void buildErdosRenyi_noloops(int an,int aconn);
	virtual void buildLayeredRNN(int ln,vector<int> lan);
	virtual void makeEdgeIndex();
	virtual void Setup(); //builds the arrays to store values
	//virtual void getFreqs(const vector<long>& datum); //get symbol frequencies
	virtual void initWeights()=0;
	virtual void setToStartAct()=0;
	virtual void observe(long symbol_read);//next observation is stored into last_symbol_read. Should not actually change current activities yet.
	virtual void computeNextAct()=0;//fills act[t+1] given act[t] and last symbol read
	virtual void computePred()=0;//fills pred[x] from current activity
	virtual long double computePred(long x)=0;//fills and returns only pred[x] (useful in case pred[x] can be computed for each x individually)
	virtual void saveParams();
	virtual void restoreParams();
	virtual void saveWParams()=0;
	virtual void restoreWParams()=0;
	virtual void saveTauParams()=0;
	virtual void restoreTauParams()=0;
	virtual void saveState()=0;virtual void restoreState()=0;
	virtual bool sample(unsigned long length,vector<long>& sampleresult,long exposuretime=1);//get a sample from current params and activities. Does not affect current state.
};

struct NeuralNetwork:public virtual PredictorNetwork{
public:

	vector<long double> act,prev_act,saved_act;  //act[i] is the activity of unit i at current time
	vector<long double> V,prev_V,saved_V;  // act[i] = actfunc (V[i])

	virtual int suggestedConn()=0;// suggestion of connectivity to balance out various terms in the algorithmic cost of training. Needs to have other parameters already set
	virtual long double actfunc(long double energy)=0;//activation function
	virtual long double deractfunc(long double activity)=0;//derivative of the activation function, EXPRESSED AS A FUNCTION OF ACTIVITY (i.e., actfunc'(invactfunc), e.g. 1-act^2 for tanh
	virtual long double invactfunc(long double activity)=0;
	virtual void Setup(); //builds the arrays to store activities etc
	virtual void saveWParams()=0;
	virtual void restoreWParams()=0;
	virtual void saveTauParams()=0;
	virtual void restoreTauParams()=0;
	virtual void saveState();
	virtual void restoreState();
	long last_symbol_read_saved;
};


struct NN_SoftMaxOutput:public virtual NeuralNetwork{
	vector<vector<long double> > w,prev_w;  //w[x][i] writing weight for symbol x at unit i
	vector<long double > wbias,prev_wbias; //wbias[x] writing bias for symbol x = writing weight from always-activated unit
	vector<long double> energy;
	void computePred();//fills pred[x]
	long double computePred(long x);//fills pred[x]
	void fillProbFromEnergy(const vector<long double>& someenergy,vector<long double>& prob);
	void saveWParams();void restoreWParams();
	virtual void Setup();

	virtual void DLossDoutparams(vector<Vector>&grad);
	virtual void DLossDV(vector<long double>&grad);
	virtual void setOutparams(vector<vector<long double*>>&outparams,vector<vector<long double>>&outdiagregul);
};

struct NN_tanhAct:public virtual NeuralNetwork{
	virtual long double actfunc(long double energy);
	virtual long double deractfunc(long double theact);
	virtual long double invactfunc(long double theact);
};

struct NN_logisticAct:public virtual NeuralNetwork{
	virtual long double actfunc(long double energy);
	virtual long double deractfunc(long double theact);
	virtual long double invactfunc(long double theact);
};

struct NN_normcdfAct:public virtual NeuralNetwork{
	virtual long double actfunc(long double energy);
	virtual long double deractfunc(long double theact);//NOT DEFINED, will return error
	virtual long double deractfuncV(long double energy);
	virtual long double invactfunc(long double theact);
};

#endif
