#ifndef _YOLL_QDMETRIC_H
#define _YOLL_QDMETRIC_H

#include<cmath>
#include<vector>
#include<eigen3/Eigen/Dense>
#include"vector.h"

using Matrix=Eigen::Matrix<long double,Eigen::Dynamic,Eigen::Dynamic>;

struct QDMetric{
	//To fix the ideas, if we consider a set of parameters vector<long double> paras, where paras[0] is a bias term
	//and paras[i] are weights terms for all i!=0, a QDMetric associated to those parameters will maintain a metric
	//term between paras[i] and paras[i] for all i (coefficient d[i]), and a metric term between paras[i] and paras[0] for all i 
	//(coefficient q[i]). The metric provided can be efficiently calculated, and can gather some relevant invariance
	//properties.
	std::vector<long double> d,q; //Symmetric matrix with diagonal d and first row q (q[0] is ignored, first coeff is d[0]).
	explicit QDMetric (long _size=0,long double lambda=0.):d(_size,lambda),q(_size,0.){};//explicit to avoid conversion from a scalar to a matrix...
	explicit QDMetric(const std::vector<long double>& _d,const std::vector<long double>& _q):d(_d),q(_q){};
	explicit QDMetric(const std::vector<long double>& _d):d(_d),q(_d.size()){};//Init to diagonal
	void solveInPlace(Vector& vec,long double regul=0);//QD inverse: replaces vec with (M+regul.Id)^{-1}.vec
	void solveInPlace(Vector& vec,const std::vector<long double>&diagregul);//QD inverse: replaces vec with (M+regul.Id)^{-1}.vec
	long double squareNorm(const Vector&vec);//square norm of vec in the metric: vec^T.M.vec
	long double dotProd(const Vector&vec1,const Vector&vec2);//dot product in the metric: vec1^T.M.vec2
	long double inverseMetricSquareNorm(const Vector&vec,long double regul=0);//square norm of vec in the inverse metric: vec^T.(M+regul.Id)^{-1}.vec
	long double inverseMetricDotProd(const Vector&vec1,const Vector&vec2,long double regul=0);//dot product in the inverse metric: vec1^T.(M+regul.Id)^{-1}.vec2
	void OuterProductUpdate(const Vector&vec,long double factor=1);//Adds factor.vec.vec^T to the current QD metric. No size checks.
	long rows()const{return d.size();}
	long cols()const{return d.size();}
	void resize(long _size){d=std::vector<long double>(_size);q=d;};//resets to 0!!
	long double& operator()(long i,long j);//returns or sets A(i,j). No checks. Setting a non-diag, non-first row/col coeff will have no effect. The first row and column point to the same thing so do not update both with operators like +=, *=...
	long double operator()(long i,long j)const;//returns A(i,j). No checks.
	QDMetric& operator*=(long double lambda);
};

struct UnitWiseMetric{
	//To fix the ideas, if we consider a set of parameters vector<long double> paras, a UnitWiseMetric associated to 
	//those parameters maintain metric information about all pairs paras[i], paras[j]. Note that in many cases, this
	//increases the complexity of the original learning algorithm. Also note that in many cases, we are far from maintaining
	//the full metric, as we tipically have a vector<vector<long double>> paras where paras[i][j] is a weight from unit i to
	//unit j. The full metric would maintain metric parameters for all quadruplets paras[i][j] paras[i'][j']
	Matrix metric;//Symmetric matrix;
	explicit UnitWiseMetric(long _size=0,long double lambda=0.):metric(Matrix::Zero(_size,_size)){}//explicit to avoid conversion from a scalar to a matrix...
        void solveInPlace(Vector& vec,long double regul=0);//Replace vec with (M+regul.Id)^{-1}.vec
	void solveInPlace(Vector& vec,const std::vector<long double>&diagregul);//QD inverse: replaces vec with (M+regul.Id)^{-1}.vec
	long double squareNorm(const Vector&vec);//square norm of vec in the metric: vec^T.M.vec
	long double dotProd(const Vector&vec1,const Vector&vec2);//dot product in the metric: vec1^T.M.vec2
	long double inverseMetricSquareNorm(const Vector&vec,long double regul=0);//square norm of vec in the inverse metric: vec^T.(M+regul.Id)^{-1}.vec
	long double inverseMetricDotProd(const Vector&vec1,const Vector&vec2,long double regul=0);//dot product in the inverse metric: vec1^T.(M+regul.Id)^{-1}.vec2
	void OuterProductUpdate(const Vector&vec,long double factor=1);//Adds factor.vec.vec^T to the current QD metric. No size checks.
	long rows()const{return metric.rows();}
	long cols()const{return metric.cols();}
	void resize(long _size){metric=Matrix::Zero(_size,_size);};//resets to 0!!
	long double& operator()(long i,long j);//returns or sets A(i,j). No checks. Setting a non-diag, non-first row/col coeff will have no effect. The first row and column point to the same thing so do not update both with operators like +=, *=...
	long double operator()(long i,long j)const;//returns A(i,j). No checks.
	UnitWiseMetric& operator*=(long double lambda);
};

struct ConstantMetric{
	//Provides a simple constant diagonal metric.
	long double lambda;
	long size;
	explicit ConstantMetric(long _size=0,long double _lambda=0.):lambda(_lambda),size(_size){}
	void solveInPlace(Vector& vec, long double regul=0);
	void solveInPlace(Vector& vec, const std::vector<long double>&diagregul);
	long double squareNorm(const Vector&vec);
	long double dotProd(const Vector&vec1,const Vector&vec2);
	long double inverseMetricSquareNorm(const Vector&vec,long double regul=0);
	long double inverseMetricDotProd(const Vector&vec1,const Vector&vec2,long double regul=0);
	void OuterProductUpdate(const Vector&vec, long double factor=1);//independant from its arguments
	long rows()const{return size;}
	long cols()const{return size;}
	void resize(long _size){lambda=0;size=_size;}
	long double& operator()(long i,long j);//do not use with i!=j
	long double operator()(long i,long j)const;//do not use with i!=j
	ConstantMetric& operator*=(long double gamma);
};


#endif

