#ifndef _NEURAL_NETWORK_RNN_H
#define _NEURAL_NETWORK_RNN_H 1

#include<iostream>
#include<vector>
#include<cmath>
#include"rand.h"
#include<cfloat>
#include<map>
#include<functional>

#include"network.h"

using namespace std;

struct RNN:public NN_SoftMaxOutput,public NN_tanhAct{
 //model is V(t+1)=W.act(t)
 //act(t)=activation(V(t))
 vector<long double> tau,prev_tau; //tau[e]  transition weight for edge e
 vector<long double> bias,prev_bias; //bias[i]  bias for unit i = transition weight from always-activated unit
 vector<vector<long double> > read,prev_read; //read[x][i] input for unit i upon reading symbol x  = transition weight from always-activated unit
 vector<long double> start,prev_start; //start[i] = value of V[i] at time 0
 
 int suggestedConn();
 virtual void Setup();
 virtual void saveTauParams();virtual void restoreTauParams();
 virtual void setToStartAct();
 virtual void computeNextAct();
 virtual void initWeights();
 
 //Functions that are to be fed to the learning algorithm.
 //Connections between model and learning algorithm are handled
 //by functions in model.h
 virtual void ApplyDFDV(vector<long double>&dv);
 virtual void MultiplyRightDFDV(vector<long double>&dv);
 virtual void DFDTheta(vector<Vector>&grad);
 virtual function<void()> SaveState();
 virtual void UpdateAct(const vector<long double>&dv);
 virtual void setTransparams(vector<vector<long double*>>&transparams,vector<vector<long double>>&transdiagregul); 
 };

#endif
