#ifndef VECTOR_H

#define VECTOR_H

#include<eigen3/Eigen/Dense>

//Wrap around Eigen's vectors
struct Vector: public Eigen::Matrix< long double , Eigen::Dynamic , 1 >
{
 long double& operator[](long i){return coeffRef(i);};
 const long double& operator[](long i)const{return coeffRef(i);};
 long double& operator()(long i){return coeffRef(i);};
 const long double& operator()(long i)const{return coeffRef(i);};
 using Eigen::Matrix< long double , Eigen::Dynamic , 1 >::Matrix;
};

#endif /* end of include guard: VECTOR_H */
