#include"../headers/network.h"
#include<boost/math/distributions.hpp>

long double inftheorysequence(long n)
{
 //return log(2.)*(1./log(n+2.)-1./log(n+3.));//sums to 1, decreases like 1/(n.(log n)^2)
 return 1./(n+1.)-1./(n+2.);//sums to 1, decreases like 1/n^2
}

PredictorNetwork::PredictorNetwork():n(0),conn(0),nedges(0)
{
 edgesrc=vector<int>(0);edgedest=vector<int>(0);
}

PredictorNetwork::~PredictorNetwork()
{}

void PredictorNetwork::Setup()
{
 pred=vector<long double>(alph,0.);
}

void PredictorNetwork::observe(long symbol_read)
{
 last_symbol_read=symbol_read;
}

void PredictorNetwork::buildCompleteGraph(int an)
{
 n=an;conn=n;nedges=n*conn;
 int i,j;
 for(i=0;i<n;i++)for(j=0;j<n;j++){
	 edgesrc.push_back(i);
	 edgedest.push_back(j);
 }
 makeEdgeIndex();
}

void PredictorNetwork::buildLayeredRNN(int ln,vector<int> lan){
	int l,i,j,cn=0;
	nedges=0;
	for(l=0;l<ln;l++){
		for(i=0;i<lan[l];i++)for(j=0;j<lan[l];j++){
			edgesrc.push_back(cn+i);
			edgedest.push_back(cn+j);
			++nedges;
		}
		if(l!=0){
			for(i=0;i<lan[l-1];i++)for(j=0;j<lan[l];j++){
				edgesrc.push_back(cn-lan[l-1]+i);
				edgedest.push_back(cn+j);
				++nedges;
			}
		}
		cn+=lan[l];
	}
	n=cn;	
	makeEdgeIndex();
}

void random_nchoosek(long n,long k,vector<long>&result)
  //returns vector containing k random distinct integers in [[0;n[[
{
 map<long,long> subst;
 result=vector<long>(k,0);
 long c;long j;long swap;
 for(c=0;c<k;c++){
   j=c+alea(n-c);
   if(subst.count(c))swap=subst[c];else swap=c;
   if(subst.count(j)){
     result[c]=subst[j];subst[j]=swap;
   }else{
     result[c]=j;subst[j]=swap;
   }
 }
}

void PredictorNetwork::buildErdosRenyi_loops(int an,int aconn)
{
 if(aconn>=an){buildCompleteGraph(an);return;}
 n=an;conn=aconn;nedges=n*conn;
 int i,j;long k;
 vector<long> nodelist;
 for(i=0;i<n;i++){
	 edgesrc.push_back(i);edgedest.push_back(i);
	 //Build a set of conn-1 nodes from 0 to n-1 distinct from i
	 random_nchoosek(n-1,conn-1,nodelist);
	 for(k=0;k<conn-1;k++)if(nodelist[k]==i)nodelist[k]=n-1;
	 for(k=0;k<conn-1;k++){
		 j=nodelist[k];
		 edgesrc.push_back(i);
		 edgedest.push_back(j);
	 }
 }
 makeEdgeIndex();
}

void PredictorNetwork::buildErdosRenyi_noloops(int an,int aconn)
{
 if(aconn>=an){buildCompleteGraph(an);return;}
 n=an;conn=aconn;nedges=n*conn;
 int i,j;long k;
 vector<long> nodelist;
 for(i=0;i<n;i++){
	 //Build a set of conn nodes from 0 to n-1 distinct from i
	 random_nchoosek(n-1,conn,nodelist);
	 for(k=0;k<conn;k++)if(nodelist[k]==i)nodelist[k]=n-1;
	 for(k=0;k<conn;k++){
		 j=nodelist[k];
		 edgesrc.push_back(i);
		 edgedest.push_back(j);
	 }
 }
 makeEdgeIndex();
}

void PredictorNetwork::makeEdgeIndex()
{
 int e;
 int i,j;
 edgesto=vector<vector<pair<int,int> > >(n);
 edgesfrom=vector<vector<pair<int,int> > >(n);
 for(e=0;e<edgesrc.size();e++){
	 i=edgesrc[e];j=edgedest[e];
	 edgesto[j].push_back(pair<int,int>(i,e));
	 edgesfrom[i].push_back(pair<int,int>(j,e));
 }
}

/*void PredictorNetwork::getFreqs(const vector<long>& adatum)
{
 readfreq=vector<long double>(alph,0.);
 predfreq=readfreq;
 unsigned long t;long x;
 for(t=0;t<adatum.size();++t){
	 x=adatum[t];
	 ++readfreq[x];
	 if(isToPredict(adatum,t))++predfreq[x];
 }
 long double s;
 for(s=0,x=0;x<alph;++x)s+=readfreq[x];
 s=1.l/s;for(x=0;x<alph;++x)readfreq[x]*=s;
 for(s=0,x=0;x<alph;++x)s+=predfreq[x];
 s=1.l/s;for(x=0;x<alph;++x)predfreq[x]*=s;

 //Last symbol is never actually used to train parameters
 readfreq[adatum[adatum.size()-1]]-=1./(adatum.size()+0.l);
 //Avoid divisions by 0
 for(x=0;x<alph;x++)if(predfreq[x]<=0.l)predfreq[x]=epsilon;
 for(x=0;x<alph;x++)if(readfreq[x]<=0.l)readfreq[x]=epsilon;
}
*/

//only makes sense if isToPredict() always set
bool PredictorNetwork::sample(unsigned long length,vector<long>& sampleresult,long exposuretime)
{
 saveState();
 sampleresult=vector<long>(length);
 unsigned long t,et;long y;long double s;
 //setToStartAct();
 for(t=0;t<length;t++){
	 computePred();
	 s=0;for(y=0;y<alph;y++)s+=pred[y];
	 s*=alea();
	 for(y=0;y<alph&&s>=0;y++)s-=pred[y];
	 y--;if(y<0)return false;
	 sampleresult[t]=y;
	 observe(y);
	 for(et=0;et<exposuretime;et++)
	  computeNextAct();
 }
 restoreState();
 return true;
}

void PredictorNetwork::saveParams()
{
 saveWParams();saveTauParams();
}

void PredictorNetwork::restoreParams()
{
 restoreWParams();restoreTauParams();
}

void NeuralNetwork::Setup()
{
 PredictorNetwork::Setup();
 act=vector<long double>(n,0.);
 V=vector<long double>(n,0.);
 prev_act=act;prev_V=V;
}

void NeuralNetwork::saveState()
{
 saved_V=V;saved_act=act;
 last_symbol_read_saved=last_symbol_read;
}

void NeuralNetwork::restoreState()
{
 V=saved_V;act=saved_act;
 last_symbol_read=last_symbol_read_saved;
}

long double NN_tanhAct::actfunc(long double energy)
{
  return tanhl(energy);
}

long double NN_tanhAct::deractfunc(long double theact)
{
  return (1.l-theact*theact);
}

long double NN_tanhAct::invactfunc(long double theact)
{
  return atanhl(theact);
}

long double NN_logisticAct::actfunc(long double energy)
{
  return 1.l/(1.l+expl(-energy));
}

long double NN_logisticAct::deractfunc(long double theact)
{
  return theact*(1.l-theact);
}

long double NN_logisticAct::invactfunc(long double theact)
{
  return logl(theact/(1.l-theact));
}

long double NN_normcdfAct::actfunc(long double energy)
{
 return .5+.5*erfl(energy/M_SQRT2);
}

long double NN_normcdfAct::deractfunc(long double energy)
{
 std::cerr<<"For normal cdf act func: use deractfunvV(V) instead of deractfunc(act)"<<endl;
 return 0;
}

long double NN_normcdfAct::deractfuncV(long double energy)
{	
 return 1./sqrtl(2*M_PI)*expl(-.5*energy*energy);
}

long double NN_normcdfAct::invactfunc(long double theact)
{
 static boost::math::normal normdist;
 if(theact<0)return -invactfunc(-theact);
 if(theact>=actfunc(8))return 8;
 return boost::math::quantile(normdist,theact);
}
